package gov.va.med.mhv.usermgmt.util.mvi;

import gov.va.med.mhv.mvi.xsd.AD;
import gov.va.med.mhv.mvi.xsd.ActClassControlAct;
import gov.va.med.mhv.mvi.xsd.CE;
import gov.va.med.mhv.mvi.xsd.COCTMT090003UV01AssignedEntity;
import gov.va.med.mhv.mvi.xsd.COCTMT090003UV01Organization;
import gov.va.med.mhv.mvi.xsd.COCTMT100002UV01Organization;
import gov.va.med.mhv.mvi.xsd.COCTMT100003UV03ContactParty;
import gov.va.med.mhv.mvi.xsd.COCTMT100003UV03Organization;
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.CommunicationFunctionType;
import gov.va.med.mhv.mvi.xsd.EN;
import gov.va.med.mhv.mvi.xsd.EntityClassDevice;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Device;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Receiver;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Sender;
import gov.va.med.mhv.mvi.xsd.MFMIMT700701UV01Custodian;
import gov.va.med.mhv.mvi.xsd.ON;
import gov.va.med.mhv.mvi.xsd.PN;
import gov.va.med.mhv.mvi.xsd.PRPAIN201301UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201301UV02MFMIMT700701UV01ControlActProcess;
import gov.va.med.mhv.mvi.xsd.PRPAIN201301UV02MFMIMT700701UV01RegistrationEvent;
import gov.va.med.mhv.mvi.xsd.PRPAIN201301UV02MFMIMT700701UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAIN201301UV02MFMIMT700701UV01Subject2;
import gov.va.med.mhv.mvi.xsd.PRPAMT201301UV02OtherIDs;
import gov.va.med.mhv.mvi.xsd.PRPAMT201301UV02Patient;
import gov.va.med.mhv.mvi.xsd.PRPAMT201301UV02Person;
import gov.va.med.mhv.mvi.xsd.ParticipationTargetSubject;
import gov.va.med.mhv.mvi.xsd.RoleClassContact;
import gov.va.med.mhv.mvi.xsd.TEL;
import gov.va.med.mhv.mvi.xsd.TS;
import gov.va.med.mhv.mvi.xsd.XActMoodIntentEvent;
import gov.va.med.mhv.mvi.xsd.PRPAIN201301UV02Document.PRPAIN201301UV02;
import gov.va.med.mhv.usermgmt.enumeration.CountryEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.GenderEnumeration;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlOptions;

public class CreateMVICorrelationRequest {
	
	
	
	
	private static final Log LOG = LogFactory.getLog(CreateMVICorrelationRequest.class);
	
	
	/**
	 * @param userProfile
	 * @param ICN
	 * @return
	 */
	public static String createCorrelationXMLRequest(UserProfile userProfile, Patient patient) {
		// Configuration Properties
		MviProperties properties = MviProperties.getInstance();
		
		if(properties.getIsMviMockCorrelationEnabled())
			return createMockCorrelationXMLRequest(); 	
		PRPAIN201301UV02Document root1301Doc = PRPAIN201301UV02Document.Factory.newInstance();
		PRPAIN201301UV02 root1301Req = root1301Doc.addNewPRPAIN201301UV02();
		root1301Req.setITSVersion(MviConstants.MVI_XML_REQ_ITS_VERSION);
		
		/*
	    <id extension="MCID-ADD-COR-1111" root="2.16.840.1.113883.3.933"/>
	    <creationTime value="20070803130624"/>
	    <interactionId extension="PRPA_IN201301UV02" root="2.16.840.1.113883.1.6"/>
	    <processingCode code="T"/>
	    <processingModeCode code="R"/>
	    <acceptAckCode code="AL"/>
		*/
		II rootId = root1301Req.addNewId();
		String mcidExtension = MviUtil.getMCIDExtension();
		long mcidUniqValue = MviUtil.getUniqueId();
		rootId.setExtension(mcidExtension + String.valueOf(mcidUniqValue) );
		rootId.setRoot(properties.getMviRootId());
		root1301Req.setId(rootId);
		
		TS creationTime = root1301Req.addNewCreationTime();
		creationTime.setValue(MviUtil.getCreationTime());
		
		II interacionId = root1301Req.addNewInteractionId();
		interacionId.setExtension(MviConstants.MVI_INTERACTION_CORREL_TYPE);
		interacionId.setRoot(properties.getMviInteractionId());
		
		CS processingCode = root1301Req.addNewProcessingCode();
		if(properties.getMviEnvType().equalsIgnoreCase("prod"))
			processingCode.setCode(MviConstants.MVI_PROCESSING_PROD_CODE);
		else
			processingCode.setCode(MviConstants.MVI_PROCESSING_NONPROD_CODE);
		CS processingModeCode = root1301Req.addNewProcessingModeCode();
		processingModeCode.setCode(MviConstants.MVI_PROCESSING_MODE_CODE);
		
		CS acceptAckCode = root1301Req.addNewAcceptAckCode();
		acceptAckCode.setCode(MviConstants.MVI_ACCEPT_ACK_CODE);
		/*
	    <receiver typeCode="RCV">
	        <device classCode="DEV" determinerCode="INSTANCE">
	            <id root="2.16.840.1.113883.4.349"/>
	            <telecom value="https://example.org/PatientFeed"/>
	        </device>
        </receiver>
		 */
		MCCIMT000100UV01Receiver receiver = root1301Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II deviceId = device.addNewId();
		deviceId.setRoot(properties.getVaOidValue());
		//TEL deviceTelecom = device.addNewTelecom();
		//deviceTelecom.setValue("https://example.org/PatientFeed");
		
		/*
		<sender typeCode="SND">
        	<device classCode="DEV" determinerCode="INSTANCE">
            	<id extension="200MH" root="2.16.840.1.113883.3.933"/>
            </device>
        </sender>
		*/
		MCCIMT000100UV01Sender sender = root1301Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II senderId = senderDevice.addNewId();
		senderId.setExtension(properties.getMviReceivingFacilityId());
		senderId.setRoot(properties.getMviRootId());
	
		//PRPAIN201301UV02MFMIMT700701UV01ControlActProcess
		/*
    	<urn:controlActProcess classCode="CACT" moodCode="EVN">
        <urn:subject typeCode="SUBJ">
        <urn:registrationEvent classCode="REG" moodCode="EVN">
        <urn:id nullFlavor="NA"/>
        <urn:statusCode code="active"/>
        <urn:subject1 typeCode="SBJ">
		 */
		PRPAIN201301UV02MFMIMT700701UV01ControlActProcess controlActProcess = root1301Req.addNewControlActProcess(); 
		root1301Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		
		PRPAIN201301UV02MFMIMT700701UV01Subject1 subject = controlActProcess.addNewSubject();
		subject.setTypeCode(MviConstants.MVI_SUBJECT_TYPE_CODE);
		
		PRPAIN201301UV02MFMIMT700701UV01RegistrationEvent registrationEvent = subject.addNewRegistrationEvent();
		registrationEvent.setClassCode("REG");
		registrationEvent.setMoodCode("EVN");
		II regId = registrationEvent.addNewId();
		regId.setNullFlavor("NA");
		
		CS regStatusCode = registrationEvent.addNewStatusCode();
		regStatusCode.setCode(MviConstants.MVI_ACTIVE_STATUS_CODE);
		
		PRPAIN201301UV02MFMIMT700701UV01Subject2 subject1 = registrationEvent.addNewSubject1();
		subject1.setTypeCode(ParticipationTargetSubject.SBJ);
		
		/*
        <patient classCode="PAT">
        <id extension="1008521868V885186^NI" root="2.16.840.1.113883.4.349"/>
        <statusCode code="active"/>
		*/
		PRPAMT201301UV02Patient pat = subject1.addNewPatient();
		pat.setClassCode(MviConstants.MVI_PATIENT_CLASS_CODE);
		
		II patientId = pat.addNewId();
		//patientId.setExtension("1008521868V885186");
		String patientIdExtension = patient.getIcn()+MviConstants.CARET_SYMBOL+properties.getMviNationalIdentifier();
		patientId.setExtension(patientIdExtension);
		patientId.setRoot(properties.getVaOidValue());
		CS patientStatusCode = pat.addNewStatusCode();
		patientStatusCode.setCode(MviConstants.MVI_ACTIVE_STATUS_CODE);
		/*
		<patientPerson>
		 */
		PRPAMT201301UV02Person patientPerson = pat.addNewPatientPerson();
		/*
        <name use="L">
			<given>START</given>
			<family>START</family>
		</name>
		*/
		PN personName = patientPerson.addNewName();
		List list = new ArrayList(); list.add("L");
		personName.setUse(list);
		String givenName1 = userProfile.getFirstName(); 
		String[] givenNameArray;
		if(userProfile.getMiddleName() != null) {
			String givenName2 = userProfile.getMiddleName();
			givenNameArray = new String[] {givenName1, givenName2};
		}
		else
			givenNameArray = new String[]  {givenName1};
		//givenNameArray = new String[] {givenName};
		personName.setGivenArray(givenNameArray);
		String familyName = userProfile.getLastName(); String[] familyNameArray = new String[] {familyName};
		personName.setFamilyArray(familyNameArray);
		/*
		<administrativeGenderCode code="M"/>
		*/
		CE genderCode = patientPerson.addNewAdministrativeGenderCode();
		if(userProfile.getGender().getName().equalsIgnoreCase(GenderEnumeration.MALE))
			genderCode.setCode(MviConstants.MVI_MALE_GENDER_CODE);
		else if(userProfile.getGender().getName().equalsIgnoreCase(GenderEnumeration.FEMALE))
			genderCode.setCode(MviConstants.MVI_FEMALE_GENDER_CODE);
		/*
		<birthTime value="10000101"/>
		 */
		TS birthTime = patientPerson.addNewBirthTime();
		SimpleDateFormat dateformatYYYYMMDD = new SimpleDateFormat("yyyyMMdd");
		StringBuilder nowYYYYMMDD = new StringBuilder( dateformatYYYYMMDD.format( userProfile.getBirthDate() ) );
		birthTime.setValue(nowYYYYMMDD.toString());
		/*
        <addr use="HP">
        <streetAddressLine>23456 34562 Street</streetAddressLine>
        <city>Chicago</city>
        <state>IL</state>
        <country>USA</country>
        <postalCode>33333</postalCode>
        </addr>
		*/
		/*
		AD address = patientPerson.addNewAddr();
		List addrlist = new ArrayList(); addrlist.add(MviConstants.MVI_DEFAULT_ADDRESS_INDICATOR);
		address.setUse(addrlist);
		String[] addressLineArray;
		String addressLine1 = userProfile.getAddressStreet1(); 
		if(userProfile.getAddressStreet2() != null) {
			String addressLine2 = userProfile.getAddressStreet2();
			addressLineArray = new String[] {addressLine1,addressLine2};
		}
		else
			addressLineArray = new String[] {addressLine1};
		address.setStreetAddressLineArray(addressLineArray);
		
		String addressCity = userProfile.getAddressCity(); String[] addressCityArray = new String[] {addressCity};
		address.setCityArray(addressCityArray);
		String addressCountry = userProfile.getAddressCountry().getName(); 
		//CR1514 - Changed USA from United States
		if(addressCountry.equalsIgnoreCase(CountryEnumeration.UNITED_STATES)) {
			addressCountry = "USA";
		}
		String[] addressCountryArray = new String[] {addressCountry};
		address.setCountryArray(addressCountryArray);
		String addressState;
		if(userProfile.getAddressCountry().getName().equalsIgnoreCase(CountryEnumeration.UNITED_STATES))
			addressState = userProfile.getAddressState().getName();
		else
			addressState = userProfile.getAddressProvince();
		String[] addressStateArray = new String[] {addressState};
		address.setStateArray(addressStateArray);
		String addressPostalCode = userProfile.getAddressPostalCode(); String[] addressPostalCodeArray = new String[] {addressPostalCode};
		address.setPostalCodeArray(addressPostalCodeArray);
		*/
		/*
		<asOtherIDs classCode="PAT">
        <id root="2.16.840.1.113883.4.349" extension="100000939^PI^523^USVHA"/>
        <scopingOrganization classCode="ORG" determinerCode="INSTANCE">
            <id root="2.16.840.1.113883.4.349"/>
        </scopingOrganization>
        */
        //PRPAMT201301UV02OtherIDs asOtherIds = patientPerson.addNewAsOtherIDs();
		PRPAMT201301UV02OtherIDs asOtherIds1 = PRPAMT201301UV02OtherIDs.Factory.newInstance();
		asOtherIds1.setClassCode(MviConstants.MVI_PATIENT_CLASS_CODE);
		II asOtherIdsId1 = asOtherIds1.addNewId();
		asOtherIdsId1.setRoot(properties.getVaOidValue());
		//asOtherIdsId1.setExtension("12345^PI^200MH^USVHA");
		//String identifierExtension ="^PI^"+properties.getMviReceivingFacilityId()+"^USVHA";
		String identifierExtension =MviConstants.CARET_SYMBOL+properties.getMviPatientIdentifier()+MviConstants.CARET_SYMBOL+properties.getMviReceivingFacilityId()+MviConstants.CARET_SYMBOL+properties.getMviFacilityAssignAuthority();
		String dfn = userProfile.getId().toString();
		String identfierExtensionFinal = dfn.concat(identifierExtension);
		asOtherIdsId1.setExtension(identfierExtensionFinal);
		COCTMT100002UV01Organization scopingOrg = asOtherIds1.addNewScopingOrganization();
		scopingOrg.setClassCode(MviConstants.MVI_SCOPE_ORG_CLASS_CODE);
		scopingOrg.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II scopingOrgId1 = scopingOrg.addNewId();
		scopingOrgId1.setRoot(properties.getVaOidValue());
		
		/*
		</asOtherIDs>
        <asOtherIDs classCode="SSN">
        	<id extension="111111111" root="2.16.840.1.113883.4.1"/>
        	<scopingOrganization classCode="ORG" determinerCode="INSTANCE">
            	<id root="2.16.840.1.113883.4.1"/>
            </scopingOrganization>
        </asOtherIDs>
        */
		PRPAMT201301UV02OtherIDs asOtherIds2 = PRPAMT201301UV02OtherIDs.Factory.newInstance();
		asOtherIds2.setClassCode(MviConstants.MVI_SSN_CLASS_CODE);
		II asOtherIdsId2 = asOtherIds2.addNewId();
		asOtherIdsId2.setRoot(properties.getMviUsssaIdentifierId());
		String formattedSSN = userProfile.getSsn().replaceAll("[\\s\\-()]", "");
		asOtherIdsId2.setExtension(formattedSSN);
		COCTMT100002UV01Organization scopingOrg2 = asOtherIds2.addNewScopingOrganization();
		scopingOrg2.setClassCode(MviConstants.MVI_SCOPE_ORG_CLASS_CODE);
		scopingOrg2.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II scopingOrgId2 = scopingOrg2.addNewId();
		scopingOrgId2.setRoot(properties.getVaOidValue());
		
		// Passing SSN because MVI wants it at their side as of 02142013
		PRPAMT201301UV02OtherIDs[] OtherIDsArray = new PRPAMT201301UV02OtherIDs[] {asOtherIds1,asOtherIds2 };
		//PRPAMT201301UV02OtherIDs[] OtherIDsArray = new PRPAMT201301UV02OtherIDs[] {asOtherIds1 };
		patientPerson.setAsOtherIDsArray(OtherIDsArray);
		
        //<!-- Not currently used by IDM. Added to support Hl7v3 XSD validation -->
		/*
        <providerOrganization classCode="ORG" determinerCode="INSTANCE">
        	<id root="1.2.840.114350.1.13.99998.8734"/>
        	<name>Good Health Clinic</name>
        	<contactParty classCode="CON">
            	<telecom value="tel:+1-342-555-8394"/>
            </contactParty>
        </providerOrganization>
		*/
		
		COCTMT100003UV03Organization providerOrg = pat.addNewProviderOrganization();
		providerOrg.setClassCode(MviConstants.MVI_SCOPE_ORG_CLASS_CODE);
		providerOrg.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II providerOrgId = providerOrg.addNewId();
		providerOrgId.setRoot(properties.getVaOidValue());
		ON instance1 = ON.Factory.newInstance();
		List onlist = new ArrayList(); onlist.add("Good Health Clinic");
		//instance1.setUse(onlist);
		ON[] providerOrgOn = new ON[] {instance1};
		providerOrg.setNameArray(providerOrgOn);
		COCTMT100003UV03ContactParty contactParty = providerOrg.addNewContactParty();
		contactParty.setClassCode(RoleClassContact.CON);
		TEL contactPartyTelecom = contactParty.addNewTelecom();
		contactPartyTelecom.setValue("tel:+1-342-555-8394");
		// ENDED HERE
		
		//<!-- Not currently used by IDM. Added to support Hl7v3 XSD validation -->
		/*
        <custodian typeCode="CST">
        <assignedEntity classCode="ASSIGNED">
            <id root="1.2.840.114350.1.13.99998.8734"/>
            <assignedOrganization classCode="ORG" determinerCode="INSTANCE">
                <name>Good Health Clinic</name>
            </assignedOrganization>
        </assignedEntity>
        </custodian>
		*/
		
		MFMIMT700701UV01Custodian custodian = registrationEvent.addNewCustodian();
		custodian.setTypeCode("CST");
		COCTMT090003UV01AssignedEntity assignedEntity = custodian.addNewAssignedEntity();
		assignedEntity.setClassCode("ASSIGNED");
		II assignedEntityId = assignedEntity.addNewId();
		assignedEntityId.setRoot(properties.getVaOidValue());
		COCTMT090003UV01Organization assignedOrganization = assignedEntity.addNewAssignedOrganization();
		assignedOrganization.setClassCode(MviConstants.MVI_SCOPE_ORG_CLASS_CODE);
		assignedOrganization.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		EN assignedOrgName = assignedOrganization.addNewName();
		
		//assignedOrganization.setNameArray(aen);
		//assignedOrganization.setNameArray(aen)
		//assignedOrgName.setset("TESTING");
		//assignedOrganization.setNameArray();
		/*
		XmlObject temp = XmlObject.Factory.newInstance();
		assignedOrgName.set(temp);
		*/
		//EN assignedOrgName = EN.Factory.newInstance();
		String name = "Good Health Clinic"; List nameArray = new ArrayList(); //nameArray.add(0, name);
		//assignedOrgName.setUse(nameArray);
		//Ended Here
		
		//Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
        options.put( XmlOptions.LOAD_LINE_NUMBERS );
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        if(LOG.isDebugEnabled())
        	LOG.debug("\n" +root1301Doc.xmlText(options));
        
        // TEST the validity of an XML
        ArrayList validationErrors = new ArrayList();
        options.setErrorListener(validationErrors);
        
        boolean valid =root1301Doc.validate(options);
        if(valid){
        	if(LOG.isDebugEnabled())
				LOG.debug("Its valid 1301 Request xml");
        }
        else{
        	if(LOG.isDebugEnabled())
				LOG.debug("Not a valid xml file");
          Iterator itr = validationErrors.iterator();
    	  if(LOG.isDebugEnabled()) {
	          while(itr.hasNext()){
	  			LOG.debug(itr.next().toString());
	          }
    	  }
        }  
		
        return root1301Doc.xmlText();
		
	}
	private static String createMockCorrelationXMLRequest() {
		PRPAIN201301UV02Document root1301Doc = PRPAIN201301UV02Document.Factory.newInstance();
		PRPAIN201301UV02 root1301Req = root1301Doc.addNewPRPAIN201301UV02();
		root1301Req.setITSVersion("XML_1.0");
		
		/*
	    <id extension="MCID-ADD-COR-1111" root="22a0f9e0-4454-11dc-a6be-3603d6866807"/>
	    <creationTime value="20070803130624"/>
	    <interactionId extension="PRPA_IN201301UV02" root="2.16.840.1.113883.1.6"/>
	    <processingCode code="T"/>
	    <processingModeCode code="R"/>
	    <acceptAckCode code="AL"/>
		*/
		II rootId = root1301Req.addNewId();
		rootId.setExtension("MCID-ADD-COR-1111");
		rootId.setRoot("22a0f9e0-4454-11dc-a6be-3603d6866807");
		root1301Req.setId(rootId);
		
		TS creationTime = root1301Req.addNewCreationTime();
		creationTime.setValue("20070803130624");
		
		II interacionId = root1301Req.addNewInteractionId();
		interacionId.setExtension("PRPA_IN201301UV02");
		interacionId.setRoot("2.16.840.1.113883.1.6");
		
		CS processingCode = root1301Req.addNewProcessingCode();
		processingCode.setCode("T");
		
		CS processingModeCode = root1301Req.addNewProcessingModeCode();
		processingModeCode.setCode("T");
		
		CS acceptAckCode = root1301Req.addNewAcceptAckCode();
		acceptAckCode.setCode("AL");
		/*
	    <receiver typeCode="RCV">
	        <device classCode="DEV" determinerCode="INSTANCE">
	            <id root="2.16.840.1.113883.4.349"/>
	            <telecom value="https://example.org/PatientFeed"/>
	        </device>
        </receiver>
		 */
		MCCIMT000100UV01Receiver receiver = root1301Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode("INSTANCE");
		II deviceId = device.addNewId();
		deviceId.setRoot("2.16.840.1.113883.4.349");
		//TEL deviceTelecom = device.addNewTelecom();
		//deviceTelecom.setValue("https://example.org/PatientFeed");
		
		/*
		<sender typeCode="SND">
        	<device classCode="DEV" determinerCode="INSTANCE">
            	<id extension="200MH" root="1.2.840.114350.1.13.99997.2.7788"/>
            </device>
        </sender>
		*/
		MCCIMT000100UV01Sender sender = root1301Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode("INSTANCE");
		II senderId = senderDevice.addNewId();
		senderId.setExtension("200MH");
		senderId.setRoot("1.2.840.114350.1.13.99997.2.7788");
	
		//PRPAIN201301UV02MFMIMT700701UV01ControlActProcess
		PRPAIN201301UV02MFMIMT700701UV01ControlActProcess controlActProcess = root1301Req.addNewControlActProcess(); 
		root1301Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		
		PRPAIN201301UV02MFMIMT700701UV01Subject1 subject = controlActProcess.addNewSubject();
		subject.setTypeCode("SUBJ");
		
		PRPAIN201301UV02MFMIMT700701UV01RegistrationEvent registrationEvent = subject.addNewRegistrationEvent();
		registrationEvent.setClassCode("REG");
		registrationEvent.setMoodCode("EVN");
		II regId = registrationEvent.addNewId();
		regId.setNullFlavor("NA");
		
		CS regStatusCode = registrationEvent.addNewStatusCode();
		regStatusCode.setCode("active");
		
		PRPAIN201301UV02MFMIMT700701UV01Subject2 subject1 = registrationEvent.addNewSubject1();
		subject1.setTypeCode(ParticipationTargetSubject.SBJ);
		
		/*
        <patient classCode="PAT">
        <id extension="1008521868V885186" root="2.16.840.1.113883.4.349"/>
        <statusCode code="active"/>
		*/
		PRPAMT201301UV02Patient patient = subject1.addNewPatient();
		patient.setClassCode("PAT");
		
		II patientId = patient.addNewId();
		patientId.setExtension("1008521868V885186");
		patientId.setRoot("2.16.840.1.113883.4.349");
		CS patientStatusCode = patient.addNewStatusCode();
		patientStatusCode.setCode("active");
		/*
		<patientPerson>
		 */
		PRPAMT201301UV02Person patientPerson = patient.addNewPatientPerson();
		/*
        <name use="L">
			<given>START</given>
			<family>START</family>
		</name>
		*/
		PN personName = patientPerson.addNewName();
		List list = new ArrayList(); list.add("L");
		personName.setUse(list);
		String givenName = "START"; String[] givenNameArray = new String[] {givenName};
		personName.setGivenArray(givenNameArray);
		String familyName = "START"; String[] familyNameArray = new String[] {familyName};
		personName.setFamilyArray(familyNameArray);
		/*
		<administrativeGenderCode code="M"/>
		*/
		CE genderCode = patientPerson.addNewAdministrativeGenderCode();
		genderCode.setCode("M");
		/*
		<birthTime value="10000101"/>
		 */
		TS birthTime = patientPerson.addNewBirthTime();
		birthTime.setValue("10000101");
		/*
        <addr use="HP">
        <streetAddressLine>23456 34562 Street</streetAddressLine>
        <city>Chicago</city>
        <state>IL</state>
        <country>USA</country>
        <postalCode>33333</postalCode>
        </addr>
		*/
		AD address = patientPerson.addNewAddr();
		List addrlist = new ArrayList(); addrlist.add("HP");
		address.setUse(addrlist);
		String addressLine1 = "23456 34562 Street"; String[] addressLineArray = new String[] {addressLine1};
		address.setStreetAddressLineArray(addressLineArray);
		String addressCity = "Chicago"; String[] addressCityArray = new String[] {addressCity};
		address.setCityArray(addressCityArray);
		String addressState = "IL"; String[] addressStateArray = new String[] {addressState};
		address.setStateArray(addressStateArray);
		String addressCountry = "USA"; String[] addressCountryArray = new String[] {addressCountry};
		address.setCountryArray(addressCountryArray);
		String addressPostalCode = "33333"; String[] addressPostalCodeArray = new String[] {addressPostalCode};
		address.setPostalCodeArray(addressPostalCodeArray);
		
		/*
		<asOtherIDs classCode="PAT">
        <id root="2.16.840.1.113883.4.349" extension="100000939^PI^523^USVHA"/>
        <scopingOrganization classCode="ORG" determinerCode="INSTANCE">
            <id root="1.2.840.114350.1.13.99997.2.3412"/>
        </scopingOrganization>
        */
        //PRPAMT201301UV02OtherIDs asOtherIds = patientPerson.addNewAsOtherIDs();
		PRPAMT201301UV02OtherIDs asOtherIds1 = PRPAMT201301UV02OtherIDs.Factory.newInstance();
		asOtherIds1.setClassCode("PAT");
		II asOtherIdsId1 = asOtherIds1.addNewId();
		asOtherIdsId1.setRoot("2.16.840.1.113883.4.349");
		asOtherIdsId1.setExtension("12345^PI^200MH^USVHA");
		COCTMT100002UV01Organization scopingOrg = asOtherIds1.addNewScopingOrganization();
		scopingOrg.setClassCode("ORG");
		scopingOrg.setDeterminerCode("INSTANCE");
		II scopingOrgId1 = scopingOrg.addNewId();
		scopingOrgId1.setRoot("1.2.840.114350.1.13.99997.2.3412");
		
		/*
		</asOtherIDs>
        <asOtherIDs classCode="SSN">
        	<id extension="111111111" root="2.16.840.1.113883.4.1"/>
        	<scopingOrganization classCode="ORG" determinerCode="INSTANCE">
            	<id root="2.16.840.1.113883.4.1"/>
            </scopingOrganization>
        </asOtherIDs>
        */
		PRPAMT201301UV02OtherIDs asOtherIds2 = PRPAMT201301UV02OtherIDs.Factory.newInstance();
		asOtherIds2.setClassCode("SSN");
		II asOtherIdsId2 = asOtherIds2.addNewId();
		asOtherIdsId2.setRoot("2.16.840.1.113883.4.1");
		asOtherIdsId2.setExtension("111111111");
		COCTMT100002UV01Organization scopingOrg2 = asOtherIds2.addNewScopingOrganization();
		scopingOrg2.setClassCode("ORG");
		scopingOrg2.setDeterminerCode("INSTANCE");
		II scopingOrgId2 = scopingOrg2.addNewId();
		scopingOrgId2.setRoot("2.16.840.1.113883.4.1");
		
		//PRPAMT201301UV02OtherIDs[] OtherIDsArray = new PRPAMT201301UV02OtherIDs[] {asOtherIds1,asOtherIds2 };
		PRPAMT201301UV02OtherIDs[] OtherIDsArray = new PRPAMT201301UV02OtherIDs[] {asOtherIds1 };
		patientPerson.setAsOtherIDsArray(OtherIDsArray);
		
        //<!-- Not currently used by IDM. Added to support Hl7v3 XSD validation -->
		/*
        <providerOrganization classCode="ORG" determinerCode="INSTANCE">
        	<id root="1.2.840.114350.1.13.99998.8734"/>
        	<name>Good Health Clinic</name>
        	<contactParty classCode="CON">
            	<telecom value="tel:+1-342-555-8394"/>
            </contactParty>
        </providerOrganization>
		*/
		
		COCTMT100003UV03Organization providerOrg = patient.addNewProviderOrganization();
		providerOrg.setClassCode("ORG");
		providerOrg.setDeterminerCode("INSTANCE");
		II providerOrgId = providerOrg.addNewId();
		providerOrgId.setRoot("1.2.840.114350.1.13.99998.8734");
		ON instance1 = ON.Factory.newInstance();
		List onlist = new ArrayList(); onlist.add("Good Health Clinic");
		//instance1.setUse(onlist);
		ON[] providerOrgOn = new ON[] {instance1};
		providerOrg.setNameArray(providerOrgOn);
		COCTMT100003UV03ContactParty contactParty = providerOrg.addNewContactParty();
		contactParty.setClassCode(RoleClassContact.CON);
		TEL contactPartyTelecom = contactParty.addNewTelecom();
		contactPartyTelecom.setValue("tel:+1-342-555-8394");
		// ENDED HERE
		
		//<!-- Not currently used by IDM. Added to support Hl7v3 XSD validation -->
		/*
        <custodian typeCode="CST">
        <assignedEntity classCode="ASSIGNED">
            <id root="1.2.840.114350.1.13.99998.8734"/>
            <assignedOrganization classCode="ORG" determinerCode="INSTANCE">
                <name>Good Health Clinic</name>
            </assignedOrganization>
        </assignedEntity>
        </custodian>
		*/
		
		MFMIMT700701UV01Custodian custodian = registrationEvent.addNewCustodian();
		custodian.setTypeCode("CST");
		COCTMT090003UV01AssignedEntity assignedEntity = custodian.addNewAssignedEntity();
		assignedEntity.setClassCode("ASSIGNED");
		II assignedEntityId = assignedEntity.addNewId();
		assignedEntityId.setRoot("1.2.840.114350.1.13.99998.8734");
		COCTMT090003UV01Organization assignedOrganization = assignedEntity.addNewAssignedOrganization();
		assignedOrganization.setClassCode("ORG");
		assignedOrganization.setDeterminerCode("INSTANCE");
		EN assignedOrgName = assignedOrganization.addNewName();
		
		//assignedOrganization.setNameArray(aen);
		//assignedOrganization.setNameArray(aen)
		//assignedOrgName.setset("TESTING");
		//assignedOrganization.setNameArray();
		/*
		XmlObject temp = XmlObject.Factory.newInstance();
		assignedOrgName.set(temp);
		*/
		//EN assignedOrgName = EN.Factory.newInstance();
		String name = "Good Health Clinic"; List nameArray = new ArrayList(); //nameArray.add(0, name);
		//assignedOrgName.setUse(nameArray);
		//Ended Here
		
		//Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
        options.put( XmlOptions.LOAD_LINE_NUMBERS );
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        if(LOG.isDebugEnabled())
        	LOG.debug("\n" +root1301Doc.xmlText(options));
        
        // TEST the validity of an XML
        ArrayList validationErrors = new ArrayList();
        options.setErrorListener(validationErrors);
        
        boolean valid =root1301Doc.validate(options);
        if(valid){
        	if(LOG.isDebugEnabled())
				LOG.debug("Its valid 1301 Request xml");
        }
        else{
        	if(LOG.isDebugEnabled())
				LOG.debug("Not a valid xml file");
          Iterator itr = validationErrors.iterator();
    	  if(LOG.isDebugEnabled()) {
	          while(itr.hasNext()){
	  			LOG.debug(itr.next().toString());
	          }
    	  }
        }  
		
        return root1301Doc.xmlText();

	}

}
